*
* Faust calculation (Faust uses a BVAR, not OLS)
* Compute impulse response function for any decomposition of sigma
*
impulse(responses=irf,model=bmmodel,decomp=%decomp(%sigma),noprint) * 108
*
* Pull out responses of GDP
*
dec vect[series] gdpresp(nvar)
do i=1,nvar
   set gdpresp(i) = irf(1,i)
end do i
*
* The CMOM of this will give the quadratic form matrix which will
* give the variance from the weights on the orthogonal components.
* The forecast error variance is the sum of the diagonal elements.
* Scale the matrix by that, so the matrix sums to one on the diagonal.
*
cmom
# gdpresp
compute vh=%cmom/%sum(%xdiag(%cmom))
*
* Compute the eigen decomposition. The largest eigenvalue will be
* the maximum percentage that any shock from an orthogonalized set
* can explain.
*
eigen vh eigval eigvect
*
* The first eigenvector gives the weights for the maximal vector
* on the columns in the original orthogonalization.
*
compute x=%decomp(%sigma)*%xcol(eigvect,1)
source c:\rats\forcefac.src
@forcedfactor(force=column) %sigma x ff
compute [rect] step0 = %xt(irf,1)
compute [rect] step4 = %xt(irf,4)
compute rcond = %xrow(step4,6)
compute pcond = %xrow(step4,2)
dec vect av(6)
nonlin av %normsqr(av)==1 %dot(rcond,av)>=0.0 %dot(pcond,av)<=0.0
compute av=%xcol(eigvect,1)
find(method=bfgs,trace) max %qform(vh,av)
end find
compute x=%decomp(%sigma)*av
v
impulse(shock=x,model=bmmodel) * 108



